float4 _Color;
float4 _OutlineColor;
float _OutlineWidth;

struct v2f
{
	float4 pos : SV_POSITION;
	float2 uv  : TEXCOORD0;
};

v2f vert( appdata_base v )
{
	v2f o;
	float4 pos = mul( UNITY_MATRIX_MVP, v.vertex );
	float width = 0.01 * _OutlineWidth;
	float4 edge_pos = v.vertex + pos.w * width * float4( v.normal, 0.0 );
	o.pos = mul( UNITY_MATRIX_MVP, edge_pos );

	return o;
}
half4 frag( v2f i ) : COLOR
{
	return half4( _OutlineColor );
}

